<?php
defined('PF_VERSION') OR exit('Access denied');
require ABSPATH . '/themes/aphrodite/options/theme_options.php';
if(isset($_POST)){
    if(isset($_POST['theme_default'])){
        $aphrodite_option = aphrodite_default();
        $aphrodite_options['version'] = '';
//        $style = set_aphrodite_css($aphrodite_option);
//        $aphrodite_option['style'] = $style;
        set_aphrodite_data($aphrodite_option);
        $success = __('Theme option is reset successfully', 'aphrodite-theme');
        unset($_SESSION['colorstyle']);
    }
}
if(!isset($aphrodite_option)) $aphrodite_option = get_aphrodite_data();
$example = __("Example: ","aphrodite-theme");
$example_color = '<p class="help-block">' . $example . 'red, blue, #000000, #fff, rgb(255,255,255), transparent, initial </p>';
$tmp_applied = array(
    'body-font-family'       => 'body ' . __('tag', 'aphrodite-theme'),
    'body-font-size'         => 'body ' . __('tag', 'aphrodite-theme'),

    'navigation-font-family' => '#nav-wrap, #nav-wrap li, #nav-wrap a',
    'navigation-font-size'   => '#nav-wrap, #nav-wrap li, #nav-wrap a',
    'navigation-color'       => '#nav-wrap, #nav-wrap li, #nav-wrap a',

    'title-font-family'      => __('tag', 'aphrodite-theme') .' (h1, ..., h6), '.__('class', 'aphrodite-theme').'(.title, .aphrodite-title)',
    'title-font-size'        => __('class', 'aphrodite-theme').'(.title, .aphrodite-title)',
    'title-color'            => __('tag', 'aphrodite-theme') .' (h1, ..., h6), '.__('class', 'aphrodite-theme').'(.title, .aphrodite-title)',

    'content-font-family'    => __('class', 'aphrodite-theme').'(.content, .aphrodite-content)',
    'content-font-size'      => __('class', 'aphrodite-theme').'(.content, .aphrodite-content)',
    'content-color'          => __('class', 'aphrodite-theme').'(.content, .aphrodite-content)',

    'bottom'                 => __('class', 'aphrodite-theme').'(.bottom-content,.bottom-content li, .bottom-content a, .bottom-content h1,..., .bottom-content h6)',

    'body-class'            => __('tag', 'aphrodite-theme') .' (a), '.__('class', 'aphrodite-theme').'(.text-color, .border-color, .background-color, bg-hover-color, .btn-link, .btn-color, .footer)',
);
$applied_label =  __("Apply for: ","aphrodite-theme");
?>
<link href="<?php echo RELATIVE_PATH; ?>/themes/aphrodite/css/theme-option.css" rel="stylesheet"
    xmlns="http://www.w3.org/1999/html">
<link href="<?php echo RELATIVE_PATH; ?>/themes/aphrodite/css/colorpicker.css" rel="stylesheet">
<link href="<?php echo RELATIVE_PATH; ?>/admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.css"
      rel="stylesheet">
<form class="form-horizontal" role="form" method="post" id="options-aphrodite-theme">
<div class="row" id="error-message">
</div>
<div class="nav-tabs-custom">
    <ul class="nav nav-tabs" id="myTab">
        <li class="active"><a href="#tab-logo" data-toggle="tab"><?php echo __('Logo', 'aphrodite-theme'); ?></a></li>
        <li><a href="#tab-background" data-toggle="tab"><?php echo __('Background', 'aphrodite-theme'); ?></a></li>
        <li><a href="#tab-color" data-toggle="tab"><?php echo __('Colors', 'aphrodite-theme'); ?></a></li>
        <li><a href="#tab-fonts" data-toggle="tab"><?php echo __('Fonts', 'aphrodite-theme'); ?></a></li>
        <li><a href="#tab-navigation" data-toggle="tab"><?php echo __('Navigation', 'aphrodite-theme'); ?></a></li>
        <li><a href="#tab-footer" data-toggle="tab"><?php echo __('Footer', 'aphrodite-theme'); ?></a></li>
        <li><a href="#tab-bottom" data-toggle="tab"><?php echo __('Bottom content', 'aphrodite-theme'); ?></a></li>
    </ul>
</div>
<div class="tab-content" style="padding-top: 20px">
<div class="tab-pane active" id="tab-logo">
    <table class="table table-bordered table-option">
        <col class="col-md-2"/>
        <tr>
            <th>
                <label class="control-label"><?php echo __('Logo type', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="radio inline">
                    <label>
                        <input type="radio" name="logo" <?php if($aphrodite_option['logo'] != 'image'){echo ' checked="checked"';} ?> value="text">
                        <?php echo __('Text', 'aphrodite-theme'); ?>
                    </label>
                </div>
                <div class="radio inline">
                    <label>
                        <input type="radio" name="logo" <?php if($aphrodite_option['logo'] == 'image'){echo ' checked="checked"'; } ?> value="image">
                        <?php echo __('Image', 'aphrodite-theme'); ?>
                    </label>
                </div>
            </td>
        </tr>
        <tbody class="logo-text">
        <tr class="logo-text">
            <th>
                <label class="control-label" for="logo-text"><?php echo __('Text', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <input type="text" class="form-control" id="logo-text" name="logo-text" value="<?php echo $aphrodite_option['logo-text']; ?>">
            </td>
        </tr>
        <tr class="logo-text">
            <th>
                <label class="control-label" for="logo-font-family">
                    <?php echo __('Font-family', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="logo-font-family" id="logo-font-family" value="<?php echo $aphrodite_option['logo-font-family']; ?>">
            </td>
        </tr>
        <tr class="logo-text">
            <th>
                <label class="control-label" for="logo-font-size">
                    <?php echo __('Font-size', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="logo-font-size" id="logo-font-size" value="<?php echo $aphrodite_option['logo-font-size']; ?>">
            </td>
        </tr>
        <tr class="logo-text">
            <th>
                <label class="control-label">
                    <?php echo __('Color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline logo-color" type="text" id="logo-color" name="logo-color" value="<?php echo $aphrodite_option['logo-color']; ?>">
                    <span class="input-group-btn color-picker logo-color" style="background-color: <?php echo $aphrodite_option['logo-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
        </tbody>
        <tfoot class="logo-image">
        <tr class="logo-image">
            <th>
                <label class="control-label" for="logo-image"><?php echo __('Image', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="input-group">
                    <input class="form-control" type="text" id="logo-image" name="logo-image"
                        value="<?php echo $aphrodite_option['logo-image']; ?>">
                        <span class="input-group-btn">
                            <a class="btn btn-default boxGetFile" type="button"
                                href="<?php echo RELATIVE_PATH . '/admin/plugins/media/filemanager/dialog.php?type=1&field_id=logo-image'; ?>"><?php echo __('Select image', 'aphrodite-theme'); ?></a>
                        </span>
                </div>
                <p class="help-block"><?php  printf(__('Example: Image size (Width: %spx, Height: %spx)', 'aphrodite-theme'), 180, 65); ?></p>
            </td>
        </tr>
        <tr class="logo-image">
            <th>
                <label class="control-label"
                    for="logo-image-width"><?php echo __('Image width', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <input class="form-control input-max-width" type="text" id="logo-image-width" name="logo-image-width"
                    value="<?php echo $aphrodite_option['logo-image-width']; ?>">
            </td>
        </tr>
        <tr class="logo-image">
            <th>
                <label class="control-label"
                    for="logo-image-height"><?php echo __('Image height', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <input class="form-control input-max-width" type="text" id="logo-image-height" name="logo-image-height"
                    value="<?php echo $aphrodite_option['logo-image-height']; ?>">
            </td>
        </tr>
        </tfoot>
    </table>
</div>
<div class="tab-pane" id="tab-background">
    <table class="table table-bordered table-configuration">
        <col class="col-md-2"/>
        <tr>
            <th>
                <label class="control-label"><?php echo __('Background type', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="radio inline">
                    <label>
                        <input type="radio" name="background" <?php if($aphrodite_option['background'] == 'color'){
                            echo ' checked="checked"';
                        } ?> value="color">
                        <?php echo __('Color', 'aphrodite-theme'); ?>
                    </label>
                </div>
                <div class="radio inline">
                    <label>
                        <input type="radio" name="background" <?php if($aphrodite_option['background'] == 'image'){
                            echo ' checked="checked"';
                        } ?> value="image">
                        <?php echo __('Image', 'aphrodite-theme'); ?>
                    </label>
                </div>
                <div class="radio inline">
                    <label>
                        <input type="radio"
                               name="background" <?php if($aphrodite_option['background'] != 'color' && $aphrodite_option['background'] != 'image'){
                            echo ' checked="checked"';
                        } ?> value="both">
                        <?php echo __('Both', 'aphrodite-theme'); ?>
                    </label>
                </div>
            </td>
        </tr>
        <tbody class="tr-background-color">
        <tr class="tr-background-color">
            <th>
                <label class="control-label" for="background-color"><?php echo __('Background color', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline background-color" type="text" id="background-color"
                        name="background-color" value="<?php echo $aphrodite_option['background-color']; ?>">
                    <span class="input-group-btn background-color color-picker" style="background-color: <?php echo $aphrodite_option['background-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
        <tr class="tr-background-color">
            <th>
                <label class="control-label" for="wrapper-background-color"><?php echo __('Wrapper background color', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline wrapper-background-color" type="text" id="wrapper-background-color"
                        name="wrapper-background-color" value="<?php echo $aphrodite_option['wrapper-background-color']; ?>">
                    <span class="input-group-btn wrapper-background-color color-picker" style="background-color: <?php echo $aphrodite_option['wrapper-background-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
        </tbody>
        <tfoot class="tr-background-image">

        <tr class="tr-background-image">
            <th>
                <label class="control-label" for="background-image"><?php echo __('Background images', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="input-group">
                    <input class="form-control" type="text" id="background-image" name="background-image"
                        value="<?php echo $aphrodite_option['background-image']; ?>">
                        <span class="input-group-btn">
                            <a class="btn btn-default boxGetFile" type="button"
                                href="<?php echo RELATIVE_PATH . '/admin/plugins/media/filemanager/dialog.php?type=1&field_id=background-image'; ?>"><?php echo __('Select image', 'aphrodite-theme'); ?></a>
                        </span>
                </div>
            </td>
        </tr>
        <tr class="tr-background-image">
            <th>
                <label class="control-label" for="background-position"><?php echo __('Background position', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <input class="form-control" type="text" id="background-position" name="background-position" value="<?php echo $aphrodite_option['background-position']; ?>" >
            </td>
        </tr>
        <tr class="tr-background-image">
            <th>
                <label class="control-label"><?php echo __('Background repeat', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="input-group">
                    <?php
                    $tmp_repeats = array(
                        'repeat'=> __('Repeat', 'aphrodite-theme'),
                        'repeat-x'=> __('Repeat-x', 'aphrodite-theme'),
                        'repeat-y'=> __('Repeat-y', 'aphrodite-theme'),
                        'no-repeat'=> __('No-repeat', 'aphrodite-theme')
                    );
                    foreach($tmp_repeats as $r_key => $r_value):
                        ?>
                        <div class="radio inline">
                            <label for="r_<?php echo $r_key; ?>">
                                <?php
                                echo '<input type="radio" name="background-repeat" id="r_'.$r_key.'" value="'.$r_key.'" '.(($aphrodite_option['background-repeat'] == $r_key) ? 'checked="checked"' : '').'>'. $r_value;
                                ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </td>
        </tr>
        <tr class="tr-background-image">
            <th>
                <label class="control-label"><?php echo __('Background attachment', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="radio inline">
                    <label>
                        <input type="radio"name="background-attachment" <?php if($aphrodite_option['background-attachment'] == 'scroll'){echo ' checked="checked"';} ?> value="scroll">
                        <?php echo __('Scroll', 'aphrodite-theme'); ?>
                    </label>
                </div>
                <div class="radio inline">
                    <label>
                        <input type="radio" name="background-attachment" <?php if($aphrodite_option['background-attachment'] == 'fixed'){ echo ' checked="checked"';} ?> value="fixed">
                        <?php echo __('Fixed', 'aphrodite-theme'); ?>
                    </label>
                </div>
            </td>
        </tr>
        </tfoot>
    </table>

</div>
<div class="tab-pane" id="tab-color">
    <table class="table table-bordered table-configuration">
        <col class="col-md-2"/>
        <tr>
            <th>
                <label class="control-label"><?php echo __('Color type', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="radio inline">
                    <label>
                        <input type="radio" name="color" <?php if($aphrodite_option['color'] == 'theme'){
                            echo ' checked="checked"';
                        } ?> value="theme">
                        <?php echo __('Theme style', 'aphrodite-theme'); ?>
                    </label>
                </div>
                <div class="radio inline">
                    <label>
                        <input type="radio" name="color" <?php if($aphrodite_option['color'] != 'theme'){
                            echo ' checked="checked"';
                        } ?> value="custom">
                        <?php echo __('Custom style', 'aphrodite-theme'); ?>
                    </label>
                </div>
            </td>
        </tr>
        <tbody class="tr-color-custom">
        <tr class="tr-color-custom">
            <th>
                <label class="control-label" for="custom_color">
                    <?php echo  __('Custom color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline custom_color" type="text" id="custom_color" name="custom_color"
                        value="<?php echo $aphrodite_option['custom_color']; ?>">
                    <span class="input-group-btn color-picker custom_color" style="background-color: <?php echo $aphrodite_option['custom_color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
                <p class="help-block"><?php echo $applied_label . $tmp_applied['body-class']; ?></p>
            </td>
        </tr>
        </tbody>
        <tfoot class="tr-color-theme">
        <tr class="tr-color-theme">
            <th>
                <label class="control-label">
                    <?php echo __('Color style', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <ul class="list-unstyled" id="option-color">
                    <?php
                        $colorStyle = array(
                            'green'=>'#27ae60',
                            'blue'=>'#3498db',
                            'red'=>'#e74c3c',
                            'amethyst'=>'#9b59b6',
                            'lblue'=> '#32c8de',
                            'black'=> '#555555',
                            'brown'=> '#bf6748',
                            'yellow'=> '#e9c51b',
                            'orange'=> '#f75353',
                            'rose'=> '#ff61e7',
                        );
                        foreach($colorStyle as $key=>$val){
                            echo "<li class=\"aphrodite-option-color".(($aphrodite_option['body-class'] == 'body-'.$key) ? ' active' : '')."\" data-class=\"body-{$key}\" style=\"background-color: {$val}\"></li>";
                        }
                    ?>
                </ul>
                <p class="help-block"><?php echo $applied_label . $tmp_applied['body-class']; ?></p>
                <input type="hidden" id="body-class" name="body-class" value="<?php echo $aphrodite_option['body-class']; ?>">
            </td>
        </tr>
        </tfoot>
    </table>
</div>
<div class="tab-pane" id="tab-fonts">
    <table class="table table-bordered table-configuration">
        <col class="col-md-2"/>
        <tr>
            <th>
                <label class="control-label" for="google-font">
                    <?php echo __('Google fonts', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="google-font" id="google-font" value="<?php echo $aphrodite_option['google-font']; ?>">
                <p class="help-block"><?php echo $example . htmlentities("<link href='http://fonts.googleapis.com/css?family=Roboto|Oswald' rel='stylesheet' type='text/css'>"); ?></p>
            </td>
        </tr>
        <?php
        $tmp_font = array(
            'body-font-family'       => __('Body font family', 'aphrodite-theme'),
            'body-font-size'         => __('Body font size', 'aphrodite-theme'),
            'title-font-family'      => __('Title font family', 'aphrodite-theme'),
            'title-font-size'        => __('Title font size', 'aphrodite-theme'),
            'content-font-family'    => __('Content font family', 'aphrodite-theme'),
            'content-font-size'      => __('Content font size', 'aphrodite-theme'),
        );
        foreach($tmp_font as $key_font => $font_value):
        ?>
        <tr>
            <th>
                <label class="control-label" for="<?php echo $key_font ?>">
                    <?php echo $font_value ?>
                </label>
            </th>
            <td>
                <?php echo '<input type="text" class="form-control" name="'.$key_font.'" id="'.$key_font.'" value="'.$aphrodite_option[$key_font].'">'; ?>
                <p class="help-block"><?php echo $applied_label . $tmp_applied[$key_font]; ?></p>
            </td>
        </tr>
        <?php
            endforeach;
        ?>
    </table>
</div>
<div class="tab-pane" id="tab-navigation">
    <table class="table table-bordered table-configuration">
        <col class="col-md-2"/>
        <tr>
            <th>
                <label class="control-label" for="navigation-color">
                    <?php echo __('Color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline navigation-color" type="text" id="navigation-color" name="navigation-color"
                           value="<?php echo $aphrodite_option['navigation-color']; ?>">
                    <span class="input-group-btn color-picker navigation-color" style="background-color: <?php echo $aphrodite_option['navigation-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
                <p class="help-block"><?php echo $applied_label . $tmp_applied['navigation-color']; ?></p>
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label" for="navigation-color">
                    <?php echo __('Color (hover, active)', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline navigation-hover-color" type="text" id="navigation-hover-color" name="navigation-hover-color"
                           value="<?php echo $aphrodite_option['navigation-hover-color']; ?>">
                    <span class="input-group-btn color-picker navigation-hover-color" style="background-color: <?php echo $aphrodite_option['navigation-hover-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
                <p class="help-block"><?php echo $applied_label . $tmp_applied['navigation-color']; ?></p>
            </td>
        </tr>
        <?php
        $tmp_font = array(
            'navigation-font-family' => __('Font-family', 'aphrodite-theme'),
            'navigation-font-size'   => __('Font-size', 'aphrodite-theme'),
        );
        foreach($tmp_font as $key_font => $font_value):
            ?>
            <tr>
                <th>
                    <label class="control-label" for="<?php echo $key_font ?>">
                        <?php echo $font_value ?>
                    </label>
                </th>
                <td>
                    <?php echo '<input type="text" class="form-control" name="'.$key_font.'" id="'.$key_font.'" value="'.$aphrodite_option[$key_font].'">'; ?>
                    <p class="help-block"><?php echo $applied_label . $tmp_applied[$key_font]; ?></p>
                </td>
            </tr>
        <?php
        endforeach;
        ?>
        <tr>
            <th>
                <label class="control-label" for="navigation-background-color">
                    <?php echo __('Background color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline navigation-background-color" type="text" id="navigation-background-color" name="navigation-background-color"
                        value="<?php echo $aphrodite_option['navigation-background-color']; ?>">
                    <span class="input-group-btn color-picker navigation-background-color" style="background-color: <?php echo $aphrodite_option['navigation-background-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
    </table>
</div>
<div class="tab-pane" id="tab-bottom">
    <table class="table table-bordered table-configuration">
        <col class="col-md-2"/>
        <tr>
            <th>
                <label class="control-label">
                    <?php echo __('Bottom content', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <textarea class="form-control" name="bottom_content" cols="90" rows="5" id="bottom_content"><?php echo $aphrodite_option['bottom_content'] ?></textarea>
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label" for="bottom-font-family">
                    <?php echo __('Font-family', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="bottom-font-family" id="bottom-font-family" value="<?php echo $aphrodite_option['bottom-font-family']; ?>">
                <p class="help-block"><?php echo $applied_label. $tmp_applied['bottom']; ?></p>
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label" for="bottom-font-size">
                    <?php echo __('Font-size', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="bottom-font-size" id="bottom-font-size" value="<?php echo $aphrodite_option['bottom-font-size']; ?>">
                <p class="help-block"><?php echo $applied_label. $tmp_applied['bottom']; ?></p>
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label">
                    <?php echo __('Color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline bottom-color" type="text" id="bottom-color" name="bottom-color" value="<?php echo $aphrodite_option['bottom-color']; ?>">
                    <span class="input-group-btn color-picker bottom-color" style="background-color: <?php echo $aphrodite_option['bottom-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
                <p class="help-block"><?php echo $applied_label. $tmp_applied['bottom']; ?></p>
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label" for="bottom-background-color">
                    <?php echo __('Background color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline bottom-background-color" type="text" id="bottom-background-color" name="bottom-background-color"
                        value="<?php echo $aphrodite_option['bottom-background-color']; ?>">
                    <span class="input-group-btn color-picker bottom-background-color" style="background-color: <?php echo $aphrodite_option['bottom-background-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
    </table>
</div>
<div class="tab-pane" id="tab-footer">
    <table class="table table-bordered table-configuration">
        <col class="col-md-2"/>
        <tr>
            <th>
                <label class="control-label" for="footer-title-font-family">
                    <?php echo __('Title font family', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="footer-title-font-family" id="footer-title-font-family" value="<?php echo $aphrodite_option['footer-title-font-family']; ?>">
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label" for="footer-title-font-size">
                    <?php echo __('Title font size', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="footer-title-font-size" id="footer-title-font-size" value="<?php echo $aphrodite_option['footer-title-font-size']; ?>">
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label">
                    <?php echo __('Title color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline footer-title-color" type="text" id="footer-title-color" name="footer-title-color" value="<?php echo $aphrodite_option['footer-title-color']; ?>">
                    <span class="input-group-btn color-picker footer-title-color" style="background-color: <?php echo $aphrodite_option['footer-title-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label" for="footer-content-font-family">
                    <?php echo __('Content font family', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="footer-content-font-family" id="footer-content-font-family" value="<?php echo $aphrodite_option['footer-content-font-family']; ?>">
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label" for="bottom-font-size">
                    <?php echo __('Content font size', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <input type="text" class="form-control" name="footer-content-font-size" id="footer-content-font-size" value="<?php echo $aphrodite_option['footer-content-font-size']; ?>">
            </td>
        </tr>
        <tr>
            <th>
                <label class="control-label">
                    <?php echo __('Content color', 'aphrodite-theme'); ?>
                </label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline footer-content-color" type="text" id="footer-content-color" name="footer-content-color" value="<?php echo $aphrodite_option['footer-content-color']; ?>">
                    <span class="input-group-btn color-picker footer-content-color" style="background-color: <?php echo $aphrodite_option['footer-content-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
        <tr class="tr-background-color">
            <th>
                <label class="control-label" for="footer-background-color"><?php echo __('Background color', 'aphrodite-theme'); ?></label>
            </th>
            <td>
                <div class="input-group input-max-width">
                    <input class="form-control inline footer-background-color" type="text" id="footer-background-color"
                           name="footer-background-color" value="<?php echo $aphrodite_option['footer-background-color']; ?>">
                    <span class="input-group-btn footer-background-color color-picker" style="background-color: <?php echo $aphrodite_option['footer-background-color']; ?>;"></span>
                </div>
                <?php echo $example_color; ?>
            </td>
        </tr>
    </table>
</div>
</div>
</form>
<div class="modal fade" id="myModal11" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="options-aphrodite-reset" method="post"><input type="hidden" value="1" name="theme_default">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel"><?php echo __('Are you sure to reset to default value?', 'aphrodite-theme'); ?></h4>
                </div>
                <div class="modal-body">
                    <div class="text-right">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo __('Cancel', 'aphrodite-theme'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo __('Ok', 'aphrodite-theme'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script type="text/javascript"
        src="<?php echo RELATIVE_PATH; ?>/admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.pack.js"></script>
<script type="text/javascript"
        src="<?php echo RELATIVE_PATH; ?>/admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js"></script>
<script type="text/javascript"
        src="<?php echo RELATIVE_PATH; ?>/admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js"></script>
<script type="text/javascript" src="<?php echo RELATIVE_PATH; ?>/includes/common/plugin/assets/base.js"></script>
<script type="text/javascript" src="<?php echo RELATIVE_PATH; ?>/themes/aphrodite/js/colorpicker.js"></script>
<script>
    var colorPicker = {
        background:"<?php echo $aphrodite_option['background-color']; ?>",
        wrapper:"<?php echo $aphrodite_option['wrapper-background-color']; ?>",
        footer:"<?php echo $aphrodite_option['footer-background-color']; ?>",
        navigation:"<?php echo $aphrodite_option['navigation-color']; ?>",
        navigationHover:"<?php echo $aphrodite_option['navigation-hover-color']; ?>",
        custom_color:"<?php echo $aphrodite_option['custom_color']; ?>",
        bottom:"<?php echo $aphrodite_option['bottom-color']; ?>",
        logo:"<?php echo $aphrodite_option['logo-color']; ?>",
        navigationBackground:"<?php echo $aphrodite_option['navigation-background-color']; ?>",
        bottomBackground:"<?php echo $aphrodite_option['bottom-background-color']; ?>",
        footerTitle:"<?php echo $aphrodite_option['footer-title-color']; ?>",
        footerContent:"<?php echo $aphrodite_option['footer-content-color']; ?>"
    };
</script>
<script type="text/javascript" src="<?php echo RELATIVE_PATH; ?>/themes/aphrodite/js/theme-option.js"></script>